/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.dto.rule;

import java.sql.Types;

import zigen.plugin.db.core.TableColumn;

public class H2DtoMappingFactory extends DefaultDtoMappingFactory {
	
	public String getJavaType(TableColumn column) {
		return getJavaType(column.getDataType());
	}
	
	public String getJavaType(int type) {
		switch (type) {
			
			case Types.NUMERIC:
			case Types.DECIMAL:
				// return "java.math.BigDecimal";
				return "Long"; // H2ł́ABigDecimalł͂ȂLong^ //$NON-NLS-1$
				
			default:
				return super.getJavaType(type);
		}
	}
}